<?php
/**
 * Plugin Name:           AutomatorWP - WP Courseware
 * Plugin URI:            https://automatorwp.com/add-ons/wp-courseware/
 * Description:           Connect AutomatorWP with WP Courseware.
 * Version:               1.0.4
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-wp-courseware
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\WP_Courseware
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_WP_Courseware {

    /**
     * @var         AutomatorWP_WP_Courseware $instance The one true AutomatorWP_WP_Courseware
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_WP_Courseware self::$instance The one true AutomatorWP_WP_Courseware
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_WP_Courseware();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WP_COURSEWARE_VER', '1.0.4' );

        // Plugin file
        define( 'AUTOMATORWP_WP_COURSEWARE_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WP_COURSEWARE_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WP_COURSEWARE_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Functions
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/ajax-functions.php';

            // Triggers
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/triggers/complete-unit.php';
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/triggers/complete-module.php';
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/triggers/complete-course.php';

            // Actions
            require_once AUTOMATORWP_WP_COURSEWARE_DIR . 'includes/actions/user-course.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'wp_courseware', array(
            'label' => 'WP Courseware',
            'icon'  => AUTOMATORWP_WP_COURSEWARE_URL . 'assets/wp-courseware.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! function_exists( 'wpcw' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_WP_Courseware instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_WP_Courseware The one true AutomatorWP_WP_Courseware
 */
function AutomatorWP_WP_Courseware() {
    return AutomatorWP_WP_Courseware::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_WP_Courseware' );
